/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.block.craft;

import cloud.lemonslice.teastory.helper.VoxelShapeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xueluoanping.teastory.block.NormalHorizontalBlock;
import xueluoanping.teastory.registry.BlockEntityRegister;

public class CatapultBoardBlock
extends NormalHorizontalBlock {
    private static final VoxelShape SHAPE = VoxelShapeHelper.createVoxelShape(0.0, 0.0, 0.0, 16.0, 2.0, 16.0);
    private static final BooleanProperty ENABLED = BlockStateProperties.f_61431_;
    private final float motion;

    public CatapultBoardBlock(float motion, BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(false)));
        this.motion = motion;
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean m_7898_(BlockState state, LevelReader pLevel, BlockPos pos) {
        return pLevel.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)pLevel, pos, Direction.UP);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{ENABLED}));
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(false)), 2);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (worldIn.m_276867_(pos)) {
            double d0 = (double)pos.m_123341_() + 0.5 + (rand.m_188500_() - 0.5);
            double d1 = (double)pos.m_123342_() + 0.125 + (rand.m_188500_() - 0.5) * 0.2;
            double d2 = (double)pos.m_123343_() + 0.5 + (rand.m_188500_() - 0.5);
            worldIn.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player.m_21120_(handIn).m_41720_() == BlockEntityRegister.BAMBOO_TRAY_ITEM.get()) {
            worldIn.m_46597_(pos, (BlockState)((Block)BlockEntityRegister.STONE_CATAPULT_BOARD_WITH_TRAY.get()).m_49966_().m_61124_((Property)f_54117_, (Comparable)((Direction)state.m_61143_((Property)f_54117_))));
            SoundType soundtype = ((Block)BlockEntityRegister.BAMBOO_TRAY.get()).m_49966_().getSoundType((LevelReader)worldIn, pos, (Entity)player);
            worldIn.m_5594_(player, pos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (worldIn.m_276867_(pos)) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(true)), 2);
            worldIn.m_186460_(pos, (Block)this, 5);
            Vec3 vec3d = switch ((Direction)state.m_61143_((Property)f_54117_)) {
                case Direction.SOUTH -> new Vec3(0.0, (double)this.motion, (double)(-this.motion));
                case Direction.EAST -> new Vec3((double)(-this.motion), (double)this.motion, 0.0);
                case Direction.WEST -> new Vec3((double)this.motion, (double)this.motion, 0.0);
                default -> new Vec3(0.0, (double)this.motion, (double)this.motion);
            };
            entityIn.f_19789_ = 0.0f;
            entityIn.m_20256_(vec3d);
        }
    }
}

